/**
 * Password Utility Functions
 */

const bcrypt = require('bcryptjs');
const logger = require('./logger');

/**
 * Hash password
 */
const hashPassword = async (password) => {
  try {
    const saltRounds = 12;
    const hashedPassword = await bcrypt.hash(password, saltRounds);
    return hashedPassword;
  } catch (error) {
    logger.error('Error hashing password:', error);
    throw error;
  }
};

/**
 * Compare password with hash
 */
const comparePassword = async (password, hashedPassword) => {
  try {
    const isMatch = await bcrypt.compare(password, hashedPassword);
    return isMatch;
  } catch (error) {
    logger.error('Error comparing password:', error);
    throw error;
  }
};

module.exports = {
  hashPassword,
  comparePassword,
};

