/**
 * KPI Calculation Utility Functions
 */

/**
 * Calculate Service Agent KPI (Out of 100)
 */
const calculateAgentKPI = (agentData) => {
  let totalScore = 0;

  // Response Time (20 points)
  // Acceptance time < 15 min = +20 pts
  if (agentData.avgResponseTime && agentData.avgResponseTime <= 15) {
    totalScore += 20;
  } else if (agentData.avgResponseTime && agentData.avgResponseTime <= 30) {
    totalScore += 15;
  } else if (agentData.avgResponseTime && agentData.avgResponseTime <= 60) {
    totalScore += 10;
  } else {
    totalScore += 5;
  }

  // Approval Rate (30 points)
  // 1st attempt approval = +30 pts
  if (agentData.approvalRate >= 95) {
    totalScore += 30;
  } else if (agentData.approvalRate >= 85) {
    totalScore += 25;
  } else if (agentData.approvalRate >= 75) {
    totalScore += 20;
  } else if (agentData.approvalRate >= 60) {
    totalScore += 15;
  } else {
    totalScore += 10;
  }

  // On-time Completion (25 points)
  // Within SLA = +25 pts
  if (agentData.onTimeCompletionRate >= 95) {
    totalScore += 25;
  } else if (agentData.onTimeCompletionRate >= 85) {
    totalScore += 20;
  } else if (agentData.onTimeCompletionRate >= 75) {
    totalScore += 15;
  } else if (agentData.onTimeCompletionRate >= 60) {
    totalScore += 10;
  } else {
    totalScore += 5;
  }

  // Quality Score (15 points)
  // Clear photos, complete notes = +15 pts
  if (agentData.qualityScore >= 90) {
    totalScore += 15;
  } else if (agentData.qualityScore >= 80) {
    totalScore += 12;
  } else if (agentData.qualityScore >= 70) {
    totalScore += 9;
  } else if (agentData.qualityScore >= 60) {
    totalScore += 6;
  } else {
    totalScore += 3;
  }

  // Customer Rating (10 points)
  // Rating > 4.5/5 = +10 pts
  if (agentData.avgCustomerRating >= 4.5) {
    totalScore += 10;
  } else if (agentData.avgCustomerRating >= 4.0) {
    totalScore += 8;
  } else if (agentData.avgCustomerRating >= 3.5) {
    totalScore += 6;
  } else if (agentData.avgCustomerRating >= 3.0) {
    totalScore += 4;
  } else {
    totalScore += 2;
  }

  return Math.min(totalScore, 100); // Cap at 100
};

/**
 * Calculate Manager KPI (Out of 100)
 */
const calculateManagerKPI = (managerData) => {
  let totalScore = 0;

  // Accuracy (40 points)
  // Jobs approved correctly = +40 pts
  if (managerData.approvalAccuracy >= 98) {
    totalScore += 40;
  } else if (managerData.approvalAccuracy >= 95) {
    totalScore += 35;
  } else if (managerData.approvalAccuracy >= 90) {
    totalScore += 30;
  } else if (managerData.approvalAccuracy >= 85) {
    totalScore += 25;
  } else {
    totalScore += 20;
  }

  // Team Performance (30 points)
  // Team avg approval > 95% = +30 pts
  if (managerData.teamAvgApprovalRate >= 95) {
    totalScore += 30;
  } else if (managerData.teamAvgApprovalRate >= 90) {
    totalScore += 25;
  } else if (managerData.teamAvgApprovalRate >= 85) {
    totalScore += 20;
  } else if (managerData.teamAvgApprovalRate >= 75) {
    totalScore += 15;
  } else {
    totalScore += 10;
  }

  // Response Time (20 points)
  // Approval < 30 min = +20 pts
  if (managerData.avgApprovalTime <= 30) {
    totalScore += 20;
  } else if (managerData.avgApprovalTime <= 60) {
    totalScore += 15;
  } else if (managerData.avgApprovalTime <= 120) {
    totalScore += 10;
  } else {
    totalScore += 5;
  }

  // Escalation Handling (10 points)
  // Proper SLA escalation = +10 pts
  if (managerData.escalationHandlingScore >= 90) {
    totalScore += 10;
  } else if (managerData.escalationHandlingScore >= 80) {
    totalScore += 8;
  } else if (managerData.escalationHandlingScore >= 70) {
    totalScore += 6;
  } else {
    totalScore += 4;
  }

  return Math.min(totalScore, 100); // Cap at 100
};

module.exports = {
  calculateAgentKPI,
  calculateManagerKPI,
};

