/**
 * Simple script to test if server is accessible
 * Run this to verify server connectivity
 */

const http = require('http');

const testUrl = process.argv[2] || 'http://192.168.0.3:3000/health';

console.log('🧪 Testing server connectivity...');
console.log(`   URL: ${testUrl}`);
console.log('');

const url = new URL(testUrl);
const options = {
  hostname: url.hostname,
  port: url.port || 3000,
  path: url.pathname,
  method: 'GET',
  timeout: 5000
};

const req = http.request(options, (res) => {
  console.log(`✅ Connection successful!`);
  console.log(`   Status: ${res.statusCode}`);
  console.log(`   Headers:`, res.headers);
  
  let data = '';
  res.on('data', (chunk) => {
    data += chunk;
  });
  
  res.on('end', () => {
    console.log(`   Response: ${data}`);
    console.log('');
    console.log('✅ Server is accessible!');
    process.exit(0);
  });
});

req.on('error', (error) => {
  console.error(`❌ Connection failed!`);
  console.error(`   Error: ${error.message}`);
  console.error('');
  console.error('Possible issues:');
  console.error('   1. Server is not running');
  console.error('   2. Firewall is blocking port 3000');
  console.error('   3. Wrong IP address or port');
  console.error('   4. Server is not listening on 0.0.0.0');
  console.error('');
  console.error('Solutions:');
  console.error('   1. Start server: cd backend && npm run dev');
  console.error('   2. Check firewall: Allow port 3000');
  console.error('   3. Verify IP: Run ipconfig to check your IP');
  console.error('   4. Check server.js listens on 0.0.0.0:3000');
  process.exit(1);
});

req.on('timeout', () => {
  console.error(`❌ Connection timeout!`);
  console.error('   Server did not respond within 5 seconds');
  req.destroy();
  process.exit(1);
});

req.end();

