/**
 * Check Super Admin User
 * Run this script to verify if Super Admin user exists
 * 
 * Usage: node scripts/checkSuperAdmin.js
 */

require('dotenv').config();
const mongoose = require('mongoose');
const User = require('../models/User.model');
const logger = require('../utils/logger');

const checkSuperAdmin = async () => {
  try {
    // Connect to MongoDB
    const mongoURI = process.env.MONGODB_URI || 'mongodb://135.181.103.182:1200/hyderabad';
    await mongoose.connect(mongoURI, {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });
    logger.info('Connected to MongoDB');

    // Check if Super Admin exists
    const superAdmin = await User.findOne({ role: 'SUPER_ADMIN' }).select('+password');
    
    if (!superAdmin) {
      logger.warn('❌ Super Admin user NOT FOUND!');
      logger.info('Run: npm run seed:superadmin');
      await mongoose.disconnect();
      process.exit(1);
    }

    logger.info('✅ Super Admin user found!');
    logger.info('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
    logger.info('📧 Email: ' + superAdmin.email);
    logger.info('👤 Name: ' + superAdmin.name);
    logger.info('🔐 Status: ' + superAdmin.status);
    logger.info('📅 Created: ' + superAdmin.createdAt);
    logger.info('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
    
    // Test password
    const { comparePassword } = require('../utils/password');
    const testPassword = process.env.SUPER_ADMIN_PASSWORD || 'SuperAdmin@123';
    const isPasswordValid = await comparePassword(testPassword, superAdmin.password);
    
    if (isPasswordValid) {
      logger.info('✅ Password is correct!');
    } else {
      logger.warn('⚠️  Password does NOT match!');
      logger.info('Expected password: ' + testPassword);
      logger.info('If you changed the password, use the new password to login.');
    }

    await mongoose.disconnect();
    process.exit(0);
  } catch (error) {
    logger.error('Error checking Super Admin:', error);
    await mongoose.disconnect();
    process.exit(1);
  }
};

checkSuperAdmin();

