/**
 * User Routes
 */

const express = require('express');
const router = express.Router();
const userController = require('../controllers/user.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// NOTE: /update-location route is now registered directly in server.js
// (before the general user routes) to ensure it's matched first and accessible
// to ALL authenticated users (EMPLOYEE, CUSTOMER, ADMIN, etc.)
// Do NOT define it here to avoid route conflicts.

// Get manager's assigned agents (accessible to MANAGER role)
// This route must be before /:id route to avoid conflicts
router.get('/my-agents', userController.getManagerAssignedAgents);

// Get users
router.get('/', authorize('ADMIN', 'SUPER_ADMIN', 'MANAGER'), userController.getUsers);

// Get user by ID
router.get('/:id', authorize('ADMIN', 'SUPER_ADMIN', 'MANAGER'), userController.getUserById);

// Create user (Admin/Super Admin only)
router.post('/', authorize('ADMIN', 'SUPER_ADMIN'), userController.validateCreateUser, userController.createUser);

// Update user
router.patch('/:id', authorize('ADMIN', 'SUPER_ADMIN', 'MANAGER'), userController.validateUpdateUser, userController.updateUser);

// Delete user (Admin/Super Admin only)
router.delete('/:id', authorize('ADMIN', 'SUPER_ADMIN'), userController.deleteUser);

// Assign agents to manager
router.post('/:managerId/assign-agents', authorize('ADMIN', 'SUPER_ADMIN'), userController.validateAssignAgents, userController.assignAgentsToManager);

module.exports = router;

