/**
 * Tenant Routes
 */

const express = require('express');
const router = express.Router();
const tenantController = require('../controllers/tenant.controller');
const { authorize } = require('../middleware/auth.middleware');

// Get tenants (Super Admin only)
router.get('/', authorize('SUPER_ADMIN'), tenantController.getTenants);

// Get tenant by ID
router.get('/:id', authorize('SUPER_ADMIN', 'ADMIN'), tenantController.getTenantById);

// Create tenant (Super Admin only)
router.post('/', authorize('SUPER_ADMIN'), tenantController.validateCreateTenant, tenantController.createTenant);

// Update tenant (Super Admin only)
router.patch('/:id', authorize('SUPER_ADMIN'), tenantController.updateTenant);

// Update white-label configuration
router.patch('/:id/white-label', authorize('SUPER_ADMIN', 'ADMIN'), tenantController.validateWhiteLabelConfig, tenantController.updateWhiteLabelConfig);

// Activate tenant (Super Admin only)
router.patch('/:id/activate', authorize('SUPER_ADMIN'), tenantController.activateTenant);

// Deactivate tenant (Super Admin only)
router.patch('/:id/deactivate', authorize('SUPER_ADMIN'), tenantController.deactivateTenant);

// Delete tenant (Super Admin only)
router.delete('/:id', authorize('SUPER_ADMIN'), tenantController.deleteTenant);

// Create default roles for all existing companies (Super Admin only)
router.post('/create-default-roles', authorize('SUPER_ADMIN'), tenantController.createDefaultRolesForAll);

module.exports = router;

