/**
 * SLA Routes
 */

const express = require('express');
const router = express.Router();
const slaController = require('../controllers/sla.controller');
const { authorize } = require('../middleware/auth.middleware');

// Monitor SLA
router.get('/monitor', authorize('ADMIN', 'MANAGER'), slaController.monitorSLA);

// Get SLA breaches
router.get('/breaches', authorize('ADMIN', 'MANAGER'), slaController.getBreaches);

// Get job SLA
router.get('/jobs/:jobId', authorize('ADMIN', 'MANAGER', 'SERVICE_AGENT'), slaController.getJobSLA);

// Escalate job
router.post('/jobs/:jobId/escalate', authorize('ADMIN', 'MANAGER', 'SERVICE_AGENT'), slaController.escalateJob);

module.exports = router;

