/**
 * Settings Routes
 */

const express = require('express');
const router = express.Router();
const settingsController = require('../controllers/settings.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// All routes require authentication
router.use(authenticateToken);

// Get settings - Allow employees, managers, agents, and customers to read their company settings
router.get('/', (req, res, next) => {
  // ADMIN, EMPLOYEE, MANAGER, SERVICE_AGENT, and CUSTOMER can read their company settings
  if (req.userRole === 'ADMIN' || req.userRole === 'EMPLOYEE' || req.userRole === 'MANAGER' || req.userRole === 'SERVICE_AGENT' || req.userRole === 'CUSTOMER') {
    return settingsController.getSettings(req, res, next);
  }
  return res.status(403).json({ 
    success: false, 
    message: 'Insufficient permissions. Settings access requires ADMIN, EMPLOYEE, MANAGER, SERVICE_AGENT, or CUSTOMER role.' 
  });
});

// Update settings
router.patch('/', settingsController.updateSettings);

// Upload logo
router.post('/logo', settingsController.uploadLogo);

// Delete logo
router.delete('/logo', settingsController.deleteLogo);

module.exports = router;

