/**
 * Role Routes
 */

const express = require('express');
const router = express.Router();
const roleController = require('../controllers/role.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// All routes require authentication and ADMIN role
router.use(authenticateToken);
router.use(authorize('ADMIN'));

// Get roles
router.get('/', roleController.getRoles);

// Get role by ID
router.get('/:id', roleController.getRoleById);

// Create role
router.post('/', roleController.validateCreateRole, roleController.createRole);

// Update role
router.patch('/:id', roleController.validateUpdateRole, roleController.updateRole);

// Delete role
router.delete('/:id', roleController.deleteRole);

module.exports = router;

