/**
 * Report Routes
 */

const express = require('express');
const router = express.Router();
const reportController = require('../controllers/report.controller');
const { authorize } = require('../middleware/auth.middleware');

// Generate report
router.post('/generate/:jobId', authorize('ADMIN', 'MANAGER'), reportController.generateReport);

// Get report by job ID
router.get('/job/:jobId', authorize('ADMIN', 'MANAGER', 'CUSTOMER'), reportController.getReportByJobId);

// Get reports
router.get('/', authorize('ADMIN', 'MANAGER', 'CUSTOMER'), reportController.getReports);

// Download report (serves the PDF file)
router.get('/:id/download', authorize('ADMIN', 'MANAGER', 'CUSTOMER'), (req, res) => {
  // This would serve the PDF file
  res.json({ message: 'Download report - implement file serving' });
});

module.exports = router;

