/**
 * Product Routes
 */

const express = require('express');
const router = express.Router();
const productController = require('../controllers/product.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// All routes require authentication
router.use(authenticateToken);

// Get products - ADMIN can see all, CUSTOMER can see their assigned products
router.get('/', (req, res, next) => {
  if (req.userRole === 'ADMIN' || req.userRole === 'EMPLOYEE') {
    return productController.getProducts(req, res);
  } else if (req.userRole === 'CUSTOMER') {
    return productController.getCustomerProducts(req, res);
  }
  return res.status(403).json({
    success: false,
    message: 'Insufficient permissions',
  });
});

// Get product by ID
router.get('/:id', productController.getProductById);

// Create product
router.post('/', productController.validateCreateProduct, productController.createProduct);

// Update product
router.patch('/:id', productController.validateUpdateProduct, productController.updateProduct);

// Delete product
router.delete('/:id', productController.deleteProduct);

module.exports = router;

