/**
 * Periodic Maintenance Configuration Routes
 */

const express = require('express');
const router = express.Router();
const periodicMaintenanceConfigController = require('../controllers/periodicMaintenanceConfig.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// Get all configurations
router.get(
  '/',
  authenticateToken,
  authorize('ADMIN', 'MANAGER'),
  periodicMaintenanceConfigController.getConfigs
);

// Get available products (for product selection)
router.get(
  '/available-products',
  authenticateToken,
  authorize('ADMIN', 'MANAGER'),
  periodicMaintenanceConfigController.getAvailableProducts
);

// Get configuration by ID
router.get(
  '/:id',
  authenticateToken,
  authorize('ADMIN', 'MANAGER', 'SERVICE_AGENT', 'EMPLOYEE'),
  periodicMaintenanceConfigController.getConfigById
);

// Create new configuration
router.post(
  '/',
  authenticateToken,
  authorize('ADMIN', 'MANAGER'),
  periodicMaintenanceConfigController.validateCreateConfig,
  periodicMaintenanceConfigController.createConfig
);

// Update configuration
router.patch(
  '/:id',
  authenticateToken,
  authorize('ADMIN', 'MANAGER'),
  periodicMaintenanceConfigController.validateUpdateConfig,
  periodicMaintenanceConfigController.updateConfig
);

// Delete configuration
router.delete(
  '/:id',
  authenticateToken,
  authorize('ADMIN', 'MANAGER'),
  periodicMaintenanceConfigController.deleteConfig
);

module.exports = router;

