/**
 * Notification Routes
 */

const express = require('express');
const router = express.Router();
const notificationController = require('../controllers/notification.controller');

// Get notifications
router.get('/', notificationController.getNotifications);

// Get notification by ID
router.get('/:id', notificationController.getNotifications);

// Mark notification as read
router.patch('/:id/read', notificationController.markRead);

// Mark all notifications as read
router.patch('/read-all', notificationController.markAllRead);

// Get unread count
router.get('/unread-count', notificationController.getUnreadCount);

module.exports = router;

