/**
 * Media Routes
 */

const express = require('express');
const router = express.Router();
const mediaController = require('../controllers/media.controller');
const mediaService = require('../services/media.service');
const { authorize } = require('../middleware/auth.middleware');

// Upload single file
router.post('/upload', authorize('SERVICE_AGENT', 'ADMIN'), mediaService.upload.single('file'), mediaController.uploadMedia);

// Upload multiple files
router.post('/upload-multiple', authorize('SERVICE_AGENT', 'ADMIN'), mediaService.upload.array('files', 10), mediaController.uploadMultiple);

// Get media by job ID
router.get('/job/:jobId', authorize('SERVICE_AGENT', 'ADMIN', 'MANAGER', 'CUSTOMER'), mediaController.getMediaByJobId);

// Delete media
router.delete('/:id', authorize('SERVICE_AGENT', 'ADMIN'), mediaController.deleteMedia);

module.exports = router;

