/**
 * KPI Matrix Routes
 */

const express = require('express');
const router = express.Router();
const kpiMatrixController = require('../controllers/kpiMatrix.controller');
const { authorize } = require('../middleware/auth.middleware');

// Get all KPI Matrices
router.get('/', authorize('ADMIN', 'MANAGER'), kpiMatrixController.getKPIMatrices);

// Get KPI Matrix by ID
router.get('/:id', authorize('ADMIN', 'MANAGER'), kpiMatrixController.getKPIMatrixById);

// Create KPI Matrix
router.post('/', authorize('ADMIN'), kpiMatrixController.validateKPIMatrix, kpiMatrixController.createKPIMatrix);

// Update KPI Matrix
router.patch('/:id', authorize('ADMIN'), kpiMatrixController.validateKPIMatrix, kpiMatrixController.updateKPIMatrix);

// Delete KPI Matrix
router.delete('/:id', authorize('ADMIN'), kpiMatrixController.deleteKPIMatrix);

module.exports = router;

