/**
 * KPI Routes
 */

const express = require('express');
const router = express.Router();
const kpiController = require('../controllers/kpi.controller');
const { authorize } = require('../middleware/auth.middleware');

// IMPORTANT: Specific routes must be defined BEFORE parameterized routes
// Otherwise, Express will match "/leaderboard" to "/:userId" route

// Get leaderboard
router.get('/leaderboard', authorize('ADMIN', 'MANAGER'), kpiController.getLeaderboard);

// Get team KPI (for manager)
router.get('/team', authorize('MANAGER'), (req, res) => {
  res.json({ message: 'Team KPI - implement aggregation' });
});

// Get organization KPI (for admin)
router.get('/organization', authorize('ADMIN'), kpiController.getOrganizationKPI);

// Get user KPI (must be last - parameterized route)
router.get('/:userId', authorize('ADMIN', 'MANAGER', 'SERVICE_AGENT'), kpiController.getUserKPI);

module.exports = router;

