/**
 * Employee Routes
 */

const express = require('express');
const router = express.Router();
const employeeController = require('../controllers/employee.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// All routes require authentication and ADMIN role
router.use(authenticateToken);
router.use(authorize('ADMIN'));

// Get employees
router.get('/', employeeController.getEmployees);

// Get employee by ID
router.get('/:id', employeeController.getEmployeeById);

// Create employee
router.post('/', employeeController.validateCreateEmployee, employeeController.createEmployee);

// Update employee
router.patch('/:id', employeeController.validateUpdateEmployee, employeeController.updateEmployee);

// Delete employee
router.delete('/:id', employeeController.deleteEmployee);

// Assign clients to employee
router.post('/:id/assign-clients', employeeController.assignClients);

// Assign jobs to employee
router.post('/:id/assign-jobs', employeeController.assignJobs);

// Create User account for employee (for Manager role)
router.post('/:id/create-user-account', employeeController.createUserAccount);

module.exports = router;

