/**
 * Customer Routes
 */

const express = require('express');
const router = express.Router();
const customerController = require('../controllers/customer.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// All routes require authentication
router.use(authenticateToken);

// Get customers - allow ADMIN, MANAGER, and EMPLOYEE (for managers to create complaints)
router.get('/', authorize('ADMIN', 'MANAGER', 'EMPLOYEE'), customerController.getCustomers);
router.get('/:id', authorize('ADMIN', 'MANAGER', 'EMPLOYEE'), customerController.getCustomerById);

// Create, update, delete - ADMIN only
router.use(authorize('ADMIN'));

// Get customers
router.get('/', customerController.getCustomers);

// Get customer by ID
router.get('/:id', customerController.getCustomerById);

// Create customer
router.post('/', customerController.validateCreateCustomer, customerController.createCustomer);

// Update customer
router.patch('/:id', customerController.validateUpdateCustomer, customerController.updateCustomer);

// Delete customer
router.delete('/:id', customerController.deleteCustomer);

module.exports = router;

