/**
 * Compliance Routes
 */

const express = require('express');
const router = express.Router();
const complianceController = require('../controllers/compliance.controller');
const complaintPhotoController = require('../controllers/complaintPhoto.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// Upload complaint photos (requires authentication)
router.post('/complaints/photos', authenticateToken, complaintPhotoController.uploadComplaintPhoto);
router.post('/complaints/photos/multiple', authenticateToken, complaintPhotoController.uploadMultipleComplaintPhotos);

// Create complaint
router.post('/complaints', authorize('CUSTOMER', 'ADMIN'), complianceController.validateCreateComplaint, complianceController.createComplaint);

// Get complaints
router.get('/complaints', authorize('CUSTOMER', 'ADMIN', 'MANAGER', 'SERVICE_AGENT', 'EMPLOYEE'), complianceController.getComplaints);

// Get complaint by ID (uses job endpoint)
// Update complaint (uses job endpoint)
// Auto-assign (handled in createComplaint)

module.exports = router;

