/**
 * Complaint Category Routes
 */

const express = require('express');
const router = express.Router();
const complaintCategoryController = require('../controllers/complaintCategory.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// All routes require authentication
router.use(authenticateToken);

// Get all categories - ADMIN and EMPLOYEE can read
router.get('/', (req, res, next) => {
  if (req.userRole === 'ADMIN' || req.userRole === 'EMPLOYEE' || req.userRole === 'CUSTOMER') {
    return complaintCategoryController.getCategories(req, res);
  }
  return res.status(403).json({
    success: false,
    message: 'Insufficient permissions',
  });
});

// Get category by ID
router.get('/:id', (req, res, next) => {
  if (req.userRole === 'ADMIN' || req.userRole === 'EMPLOYEE' || req.userRole === 'CUSTOMER') {
    return complaintCategoryController.getCategoryById(req, res);
  }
  return res.status(403).json({
    success: false,
    message: 'Insufficient permissions',
  });
});

// Create, update, delete - Only ADMIN
router.post(
  '/',
  authorize('ADMIN'),
  complaintCategoryController.validateCreateCategory,
  complaintCategoryController.createCategory
);

router.patch(
  '/:id',
  authorize('ADMIN'),
  complaintCategoryController.validateUpdateCategory,
  complaintCategoryController.updateCategory
);

router.delete(
  '/:id',
  authorize('ADMIN'),
  complaintCategoryController.deleteCategory
);

module.exports = router;

