/**
 * Audit Log Routes
 */

const express = require('express');
const router = express.Router();
const auditLogController = require('../controllers/auditLog.controller');
const { authorize } = require('../middleware/auth.middleware');

// Get audit logs
router.get('/', authorize('ADMIN', 'SUPER_ADMIN'), auditLogController.getAuditLogs);

// Get audit logs by entity
router.get('/:entityType/:entityId', authorize('ADMIN', 'SUPER_ADMIN'), auditLogController.getAuditLogsByEntity);

module.exports = router;

