/**
 * Attendance Routes
 */

const express = require('express');
const router = express.Router();
const attendanceController = require('../controllers/attendance.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// All routes require authentication
router.use(authenticateToken);

// Get attendances
router.get('/', authorize('ADMIN', 'MANAGER', 'EMPLOYEE'), attendanceController.getAttendances);

// Get attendance statistics
router.get('/stats', authorize('ADMIN', 'MANAGER'), attendanceController.getAttendanceStats);

// Get attendance by ID
router.get('/:id', authorize('ADMIN', 'MANAGER', 'EMPLOYEE'), attendanceController.getAttendanceById);

// Check-in
router.post('/check-in', authorize('EMPLOYEE', 'SERVICE_AGENT'), attendanceController.checkIn);

// Check-out
router.post('/check-out', authorize('EMPLOYEE', 'SERVICE_AGENT'), attendanceController.checkOut);

// Add break
router.post('/break', authorize('EMPLOYEE', 'SERVICE_AGENT'), attendanceController.addBreak);

// End break
router.post('/break/end', authorize('EMPLOYEE', 'SERVICE_AGENT'), attendanceController.endBreak);

// Update attendance (admin/manager only)
router.patch('/:id', authorize('ADMIN', 'MANAGER'), attendanceController.updateAttendance);

module.exports = router;

