/**
 * Approval Routes
 */

const express = require('express');
const router = express.Router();
const approvalController = require('../controllers/approval.controller');
const { authorize } = require('../middleware/auth.middleware');

// Get pending approvals
router.get('/pending', authorize('MANAGER'), approvalController.getPendingApprovals);

// Approve job (Manager or Employee with Manager roleName)
router.patch('/:id/approve', authorize('MANAGER', 'EMPLOYEE'), approvalController.validateApprove, approvalController.approveJob);

// Reject job (Manager or Employee with Manager roleName)
router.patch('/:id/reject', authorize('MANAGER', 'EMPLOYEE'), approvalController.validateReject, approvalController.rejectJob);

module.exports = router;

