/**
 * Activity Tracking Routes
 */

const express = require('express');
const router = express.Router();
const activityTrackingController = require('../controllers/activityTracking.controller');
const { authenticateToken, authorize } = require('../middleware/auth.middleware');

// All routes require authentication
router.use(authenticateToken);

// Get activities
router.get('/', authorize('ADMIN', 'MANAGER'), activityTrackingController.getActivities);

// Get activity statistics
router.get('/stats', authorize('ADMIN', 'MANAGER'), activityTrackingController.getActivityStats);

// Get user activity timeline
router.get('/user/:userId', authorize('ADMIN', 'MANAGER'), activityTrackingController.getUserActivityTimeline);

module.exports = router;

