/**
 * User Activity Model
 * Tracks user location and activity updates
 */

const mongoose = require('mongoose');

const userActivitySchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    refPath: 'userModel',
    required: true,
    index: true,
  },
  userModel: {
    type: String,
    required: true,
    enum: ['User', 'Employee', 'Customer'],
  },
  tenantId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
    required: true,
    index: true,
  },
  activityType: {
    type: String,
    enum: ['LOCATION_UPDATE', 'LOGIN', 'LOGOUT', 'JOB_START', 'JOB_COMPLETE'],
    required: true,
    default: 'LOCATION_UPDATE',
  },
  location: {
    latitude: {
      type: Number,
      required: function() {
        return this.activityType === 'LOCATION_UPDATE';
      },
    },
    longitude: {
      type: Number,
      required: function() {
        return this.activityType === 'LOCATION_UPDATE';
      },
    },
    locationName: {
      type: String,
    },
    address: {
      type: String,
    },
  },
  metadata: {
    type: mongoose.Schema.Types.Mixed,
    default: {},
  },
  ipAddress: {
    type: String,
  },
  userAgent: {
    type: String,
  },
}, {
  timestamps: true,
  collection: 'user_activities',
});

// Index for efficient queries
userActivitySchema.index({ userId: 1, createdAt: -1 });
userActivitySchema.index({ tenantId: 1, createdAt: -1 });
userActivitySchema.index({ activityType: 1, createdAt: -1 });

module.exports = mongoose.model('UserActivity', userActivitySchema);

