/**
 * Role Model
 * Predefined roles with permissions that can be assigned to employees
 */

const mongoose = require('mongoose');

const roleSchema = new mongoose.Schema({
  tenantId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
    required: true,
    index: true,
  },
  name: {
    type: String,
    required: true,
    trim: true,
  },
  description: {
    type: String,
    trim: true,
  },
  // Role-based permissions
  permissions: {
    reports: {
      create: { type: Boolean, default: false },
      view: { type: Boolean, default: false },
      editUpdate: { type: Boolean, default: false }, // Combined edit/update
      delete: { type: Boolean, default: false },
    },
    customerManagement: {
      create: { type: Boolean, default: false },
      view: { type: Boolean, default: false },
      editUpdate: { type: Boolean, default: false }, // Combined edit/update
      delete: { type: Boolean, default: false },
    },
    agentsManagement: {
      create: { type: Boolean, default: false },
      view: { type: Boolean, default: false },
      editUpdate: { type: Boolean, default: false }, // Combined edit/update
      delete: { type: Boolean, default: false },
    },
    jobsManagement: {
      create: { type: Boolean, default: false },
      view: { type: Boolean, default: false },
      edit: { type: Boolean, default: false },
      update: { type: Boolean, default: false },
      assignToAgents: { type: Boolean, default: false },
      approveReject: { type: Boolean, default: false },
    },
  },
  isDefault: {
    type: Boolean,
    default: false,
  },
  status: {
    type: String,
    enum: ['ACTIVE', 'INACTIVE'],
    default: 'ACTIVE',
  },
  createdBy: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
  },
}, {
  timestamps: true,
});

// Ensure only one default role per tenant
roleSchema.index({ tenantId: 1, isDefault: 1 });

module.exports = mongoose.model('Role', roleSchema);

