/**
 * Report Model
 */

const mongoose = require('mongoose');

const reportSchema = new mongoose.Schema({
  jobId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Job',
    required: true,
    unique: true,
    index: true,
  },
  tenantId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
    required: true,
    index: true,
  },
  reportNumber: {
    type: String,
    unique: true,
    index: true,
  },
  pdfFileUrl: {
    type: String,
    required: true,
  },
  generatedAt: {
    type: Date,
    default: Date.now,
  },
  sentToCustomerAt: {
    type: Date,
  },
  archived: {
    type: Boolean,
    default: false,
  },
}, {
  timestamps: true,
});

// Generate report number before saving
reportSchema.pre('save', async function(next) {
  if (!this.reportNumber) {
    const count = await mongoose.model('Report').countDocuments({ tenantId: this.tenantId });
    this.reportNumber = `RPT-${String(count + 1).padStart(6, '0')}`;
  }
  next();
});

module.exports = mongoose.model('Report', reportSchema);

