/**
 * Notification Model
 */

const mongoose = require('mongoose');

const notificationSchema = new mongoose.Schema({
  tenantId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
    required: true,
    index: true,
  },
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true,
    index: true,
  },
  jobId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Job',
  },
  title: {
    type: String,
    required: true,
  },
  message: {
    type: String,
    required: true,
  },
  notificationType: {
    type: String,
    enum: ['JOB_ASSIGNED', 'JOB_ACCEPTED', 'JOB_COMPLETED', 'APPROVAL_REQUIRED', 'APPROVAL_APPROVED', 'APPROVAL_REJECTED', 'SLA_BREACH', 'SYSTEM'],
    required: true,
  },
  isRead: {
    type: Boolean,
    default: false,
    index: true,
  },
  notificationChannel: {
    type: String,
    enum: ['IN_APP', 'EMAIL', 'PUSH', 'SMS'],
    default: 'IN_APP',
  },
  sentAt: {
    type: Date,
    default: Date.now,
  },
  readAt: {
    type: Date,
  },
}, {
  timestamps: true,
});

// Indexes
notificationSchema.index({ tenantId: 1, userId: 1, isRead: 1 });
notificationSchema.index({ userId: 1, isRead: 1, createdAt: -1 });

module.exports = mongoose.model('Notification', notificationSchema);

