/**
 * Media Model
 */

const mongoose = require('mongoose');

const mediaSchema = new mongoose.Schema({
  jobId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Job',
    required: true,
    index: true,
  },
  tenantId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
    required: true,
    index: true,
  },
  mediaType: {
    type: String,
    enum: ['PHOTO', 'VIDEO', 'DOCUMENT'],
    default: 'PHOTO',
  },
  fileUrl: {
    type: String,
    required: true,
  },
  fileSizeKb: {
    type: Number,
  },
  uploadedByUserId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true,
  },
  caption: {
    type: String,
  },
  isBeforePhoto: {
    type: Boolean,
    default: false,
  },
  isAfterPhoto: {
    type: Boolean,
    default: false,
  },
}, {
  timestamps: true,
});

// Indexes
mediaSchema.index({ jobId: 1 });
mediaSchema.index({ tenantId: 1 });

module.exports = mongoose.model('Media', mediaSchema);

