/**
 * KPI Score Model
 */

const mongoose = require('mongoose');

const kpiScoreSchema = new mongoose.Schema({
  tenantId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
    required: true,
    index: true,
  },
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true,
    index: true,
  },
  role: {
    type: String,
    enum: ['SERVICE_AGENT', 'MANAGER'],
    required: true,
  },
  scoreDate: {
    type: Date,
    required: true,
    index: true,
  },
  // Agent KPI components
  responseTimeScore: {
    type: Number,
    default: 0,
  },
  approvalRateScore: {
    type: Number,
    default: 0,
  },
  onTimeScore: {
    type: Number,
    default: 0,
  },
  qualityScore: {
    type: Number,
    default: 0,
  },
  customerRatingScore: {
    type: Number,
    default: 0,
  },
  // Manager KPI components
  accuracyScore: {
    type: Number,
    default: 0,
  },
  teamPerformanceScore: {
    type: Number,
    default: 0,
  },
  escalationHandlingScore: {
    type: Number,
    default: 0,
  },
  // Total score
  totalScore: {
    type: Number,
    default: 0,
    min: 0,
    max: 100,
  },
  // Metrics
  totalJobs: {
    type: Number,
    default: 0,
  },
  completedJobs: {
    type: Number,
    default: 0,
  },
  approvedJobs: {
    type: Number,
    default: 0,
  },
  rejectedJobs: {
    type: Number,
    default: 0,
  },
}, {
  timestamps: true,
});

// Indexes
kpiScoreSchema.index({ tenantId: 1, userId: 1, scoreDate: -1 });
kpiScoreSchema.index({ tenantId: 1, role: 1, scoreDate: -1 });

module.exports = mongoose.model('KPIScore', kpiScoreSchema);

