/**
 * Job Work Details Model
 */

const mongoose = require('mongoose');

const jobWorkDetailsSchema = new mongoose.Schema({
  jobId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Job',
    required: true,
    unique: true,
    index: true,
  },
  workNotes: {
    type: String,
    required: false, // Only required when submitting, not when starting
  },
  workCompletedFully: {
    type: Boolean,
    default: true,
  },
  // Spares required
  sparesRequired: [{
    name: String,
    quantity: Number,
    description: String,
    urgent: Boolean,
  }],
  customerDigitalSignatureUrl: {
    type: String,
  },
  customerSignatureData: {
    type: String, // Base64 encoded signature
  },
  // Signee information
  signeeName: {
    type: String,
  },
  // Status update description/remarks
  statusUpdateDescription: {
    type: String,
  },
  // GPS validation
  startLocationVerified: {
    type: Boolean,
    default: false,
  },
  startLocationLat: {
    type: Number,
  },
  startLocationLng: {
    type: Number,
  },
  endLocationVerified: {
    type: Boolean,
    default: false,
  },
  endLocationLat: {
    type: Number,
  },
  endLocationLng: {
    type: Number,
  },
  // Work duration
  workDurationMinutes: {
    type: Number,
  },
  // Monitoring required
  monitoringRequired: {
    type: Boolean,
    default: false,
  },
}, {
  timestamps: true,
});

module.exports = mongoose.model('JobWorkDetails', jobWorkDetailsSchema);

