/**
 * Job Approval Model
 */

const mongoose = require('mongoose');

const jobApprovalSchema = new mongoose.Schema({
  jobId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Job',
    required: true,
    unique: true,
    index: true,
  },
  tenantId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
    required: true,
    index: true,
  },
  managerId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true,
    index: true,
  },
  approvalStatus: {
    type: String,
    enum: ['PENDING', 'APPROVED', 'REJECTED'],
    default: 'PENDING',
  },
  comments: {
    type: String,
  },
  rejectionReason: {
    type: String,
    enum: ['PHOTOS_NOT_CLEAR', 'INCOMPLETE_WORK', 'MISSING_SIGNATURE', 'POOR_QUALITY', 'OTHER'],
  },
  approvedAt: {
    type: Date,
  },
  rejectedAt: {
    type: Date,
  },
}, {
  timestamps: true,
});

// Indexes
jobApprovalSchema.index({ tenantId: 1, managerId: 1 });
jobApprovalSchema.index({ tenantId: 1, approvalStatus: 1 });

module.exports = mongoose.model('JobApproval', jobApprovalSchema);

