/**
 * Complaint Category Model
 * Manages complaint categories for the system
 */

const mongoose = require('mongoose');

const complaintCategorySchema = new mongoose.Schema({
  tenantId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
    required: true,
    index: true,
  },
  name: {
    type: String,
    required: true,
    trim: true,
  },
  description: {
    type: String,
    trim: true,
  },
  isActive: {
    type: Boolean,
    default: true,
  },
  priority: {
    type: String,
    enum: ['Critical', 'Non-Critical', 'GENERAL'],
    default: 'Non-Critical',
  },
  createdBy: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
  },
}, {
  timestamps: true,
  collection: 'complaint_categories',
});

// Index for efficient queries
complaintCategorySchema.index({ tenantId: 1, isActive: 1 });
complaintCategorySchema.index({ name: 1, tenantId: 1 }, { unique: true });

module.exports = mongoose.model('ComplaintCategory', complaintCategorySchema);

