const cron = require('node-cron');
const Job = require('../models/Job.model');
const logger = require('../utils/logger');
const { assignAgentToJob } = require('../services/job.service');

const startAutoAssignCron = () => {
  // Run every minute
  cron.schedule('* * * * *', async () => {
    try {
      logger.info('Auto-assign cron: scanning for unassigned NEW jobs');

      const jobs = await Job.find({
        status: 'NEW',
        $or: [ { assignedAgentId: { $exists: false } }, { assignedAgentId: null } ]
      }).limit(100);

      for (const job of jobs) {
        try {
          await assignAgentToJob(job._id, job.tenantId);
        } catch (err) {
          logger.warn('Auto-assign failed for job', { jobId: job._id, err: err.message });
        }
      }
    } catch (error) {
      logger.error('Auto-assign cron error:', error);
    }
  }, {
    scheduled: true,
    timezone: 'UTC'
  });

  logger.info('Auto-assign cron scheduled to run every minute');
};

module.exports = { startAutoAssignCron };
