/**
 * Create .env file from template
 * Run: node create-env.js
 */

const fs = require('fs');
const path = require('path');

const envContent = `# ============================================
# HRQ Backend Environment Configuration
# ============================================
# Generated automatically - Update values as needed

# ============================================
# Application Configuration
# ============================================
NODE_ENV=development
PORT=3000
LOG_LEVEL=info

# ============================================
# Database Configuration
# ============================================
MONGODB_URI=mongodb://135.181.103.182:1200/hyderabad

# ============================================
# JWT Configuration (REQUIRED)
# ============================================
JWT_SECRET=hrq-super-secret-jwt-key-minimum-32-characters-for-security-2024
JWT_EXPIRATION=2h
REFRESH_TOKEN_EXPIRATION=7d

# ============================================
# CORS Configuration
# ============================================
CORS_ORIGIN=http://localhost:3001,http://localhost:3002,http://localhost:5173

# ============================================
# Super Admin Credentials (for seeding)
# ============================================
SUPER_ADMIN_EMAIL=superadmin@hrq.com
SUPER_ADMIN_PASSWORD=SuperAdmin@123
SUPER_ADMIN_NAME=Super Admin
SUPER_ADMIN_PHONE=

# ============================================
# Email Configuration (Optional)
# ============================================
# EMAIL_HOST=smtp.gmail.com
# EMAIL_PORT=587
# EMAIL_USER=your-email@gmail.com
# EMAIL_PASS=your-app-password
# EMAIL_FROM=noreply@hrq.com

# ============================================
# SMS Configuration (Optional - Twilio)
# ============================================
# TWILIO_ACCOUNT_SID=your-account-sid
# TWILIO_AUTH_TOKEN=your-auth-token
# TWILIO_PHONE_NUMBER=+1234567890

# ============================================
# File Upload Configuration (Optional)
# ============================================
# UPLOAD_DIR=./uploads
# MAX_FILE_SIZE=5242880
# ALLOWED_FILE_TYPES=jpg,jpeg,png,pdf

# ============================================
# Redis Configuration (Optional)
# ============================================
# REDIS_HOST=localhost
# REDIS_PORT=6379
# REDIS_PASSWORD=
# REDIS_DB=0

# ============================================
# AWS S3 Configuration (Optional)
# ============================================
# AWS_S3_BUCKET=hrq-uploads
# AWS_S3_REGION=us-east-1
# AWS_ACCESS_KEY_ID=your-access-key
# AWS_SECRET_ACCESS_KEY=your-secret-key

# ============================================
# Rate Limiting
# ============================================
RATE_LIMIT_WINDOW_MS=900000
RATE_LIMIT_MAX_REQUESTS=100

# ============================================
# Security
# ============================================
BCRYPT_SALT_ROUNDS=12

# ============================================
# Logging
# ============================================
LOG_DIR=./logs
LOG_MAX_SIZE=10m
LOG_MAX_FILES=14d

# ============================================
# Google Maps API Configuration
# ============================================
GOOGLE_MAPS_API_KEY=AIzaSyDZzxdsmCsM5skWb4jRmXJrHY4T8s28xUQ
`;

const envPath = path.join(__dirname, '.env');

try {
  // Check if .env already exists
  if (fs.existsSync(envPath)) {
    console.log('⚠️  .env file already exists!');
    console.log('   Updating with new values...');
    // Continue to overwrite
  }

  // Create .env file
  fs.writeFileSync(envPath, envContent, 'utf8');
  console.log('✅ .env file created successfully!');
  console.log('📝 Location: ' + envPath);
  console.log('');
  console.log('⚠️  Important:');
  console.log('   - Update JWT_SECRET with a secure random value');
  console.log('   - Change SUPER_ADMIN_PASSWORD after first login');
  console.log('   - Never commit .env file to git');
  console.log('');
  console.log('🚀 Next steps:');
  console.log('   1. Review and update .env file if needed');
  console.log('   2. Run: npm run seed:superadmin');
  console.log('   3. Start server: npm run dev');
} catch (error) {
  console.error('❌ Error creating .env file:', error.message);
  process.exit(1);
}

