/**
 * SLA Controller
 */

const slaService = require('../services/sla.service');
const { successResponse, errorResponse } = require('../utils/response');

const monitorSLA = async (req, res) => {
  try {
    const result = await slaService.monitorSLA(req.tenantId);
    return successResponse(res, result, 'SLA monitoring completed');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to monitor SLA', 500);
  }
};

const getBreaches = async (req, res) => {
  try {
    const filters = {
      priority: req.query.priority,
    };
    const breaches = await slaService.getSLABreaches(req.tenantId, filters);
    return successResponse(res, breaches, 'SLA breaches retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve SLA breaches', 500);
  }
};

const getJobSLA = async (req, res) => {
  try {
    const { jobId } = req.params;
    const sla = await slaService.getJobSLA(jobId, req.tenantId);
    return successResponse(res, sla, 'Job SLA retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve job SLA', 500);
  }
};

const escalateJob = async (req, res) => {
  try {
    const { jobId } = req.params;
    const result = await slaService.escalateJob(jobId, req.tenantId, req.userId);
    return successResponse(res, result, 'Job escalated successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to escalate job', 400);
  }
};

module.exports = {
  monitorSLA,
  getBreaches,
  getJobSLA,
  escalateJob,
};

