/**
 * Report Controller
 */

const reportService = require('../services/report.service');
const { successResponse, errorResponse } = require('../utils/response');

const generateReport = async (req, res) => {
  try {
    const { jobId } = req.params;
    const report = await reportService.generateReport(jobId, req.tenantId);
    return successResponse(res, report, 'Report generated successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to generate report', 400);
  }
};

const getReportByJobId = async (req, res) => {
  try {
    const { jobId } = req.params;
    const report = await reportService.getReportByJobId(jobId, req.tenantId);
    return successResponse(res, report, 'Report retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve report', 404);
  }
};

const getReports = async (req, res) => {
  try {
    const filters = {};
    const reports = await reportService.getReports(filters, req.tenantId, req.userRole, req.userId);
    return successResponse(res, reports, 'Reports retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve reports', 500);
  }
};

module.exports = {
  generateReport,
  getReportByJobId,
  getReports,
};

