/**
 * Notification Controller
 */

const notificationService = require('../services/notification.service');
const { successResponse, errorResponse } = require('../utils/response');

const getNotifications = async (req, res) => {
  try {
    const filters = {
      isRead: req.query.isRead !== undefined ? req.query.isRead === 'true' : undefined,
      notificationType: req.query.notificationType,
      limit: parseInt(req.query.limit) || 50,
    };

    const notifications = await notificationService.getNotifications(
      req.userId,
      req.tenantId,
      filters
    );

    return successResponse(res, notifications, 'Notifications retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve notifications', 500);
  }
};

const markRead = async (req, res) => {
  try {
    const { id } = req.params;
    const notification = await notificationService.markNotificationRead(
      id,
      req.userId,
      req.tenantId
    );
    return successResponse(res, notification, 'Notification marked as read');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to mark notification as read', 400);
  }
};

const markAllRead = async (req, res) => {
  try {
    const result = await notificationService.markAllNotificationsRead(req.userId, req.tenantId);
    return successResponse(res, result, 'All notifications marked as read');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to mark all notifications as read', 400);
  }
};

const getUnreadCount = async (req, res) => {
  try {
    const result = await notificationService.getUnreadCount(req.userId, req.tenantId);
    return successResponse(res, result, 'Unread count retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve unread count', 500);
  }
};

module.exports = {
  getNotifications,
  markRead,
  markAllRead,
  getUnreadCount,
};

