/**
 * KPI Controller
 */

const kpiService = require('../services/kpi.service');
const { successResponse, errorResponse } = require('../utils/response');

const getUserKPI = async (req, res) => {
  try {
    const { userId } = req.params;
    const kpi = await kpiService.getUserKPI(userId, req.tenantId);
    return successResponse(res, kpi, 'KPI retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve KPI', 500);
  }
};

const getLeaderboard = async (req, res) => {
  try {
    const role = req.query.role || 'SERVICE_AGENT';
    const limit = parseInt(req.query.limit) || 10;
    const leaderboard = await kpiService.getLeaderboard(req.tenantId, role, limit);
    return successResponse(res, leaderboard, 'Leaderboard retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve leaderboard', 500);
  }
};

const getOrganizationKPI = async (req, res) => {
  try {
    const orgKPI = await kpiService.getOrganizationKPI(req.tenantId);
    return successResponse(res, orgKPI, 'Organization KPI retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve organization KPI', 500);
  }
};

module.exports = {
  getUserKPI,
  getLeaderboard,
  getOrganizationKPI,
};

