/**
 * Dashboard Controller
 */

const dashboardService = require('../services/dashboard.service');
const { successResponse, errorResponse } = require('../utils/response');

const getStats = async (req, res) => {
  try {
    let stats;

    switch (req.userRole) {
      case 'SUPER_ADMIN':
        // Super Admin can access super admin dashboard
        if (req.path && req.path.includes('super-admin')) {
          stats = await dashboardService.getSuperAdminDashboardStats();
        } else {
          // Or regular admin dashboard if they have a tenant
          stats = req.tenantId 
            ? await dashboardService.getAdminDashboardStats(req.tenantId)
            : await dashboardService.getSuperAdminDashboardStats();
        }
        break;
      case 'ADMIN':
        stats = await dashboardService.getAdminDashboardStats(req.tenantId);
        break;
      case 'MANAGER':
        stats = await dashboardService.getManagerDashboardStats(req.userId, req.tenantId);
        break;
      case 'SERVICE_AGENT':
        stats = await dashboardService.getAgentDashboardStats(req.userId, req.tenantId);
        break;
      case 'EMPLOYEE':
        // Employees can access agent dashboard stats
        stats = await dashboardService.getAgentDashboardStats(req.userId, req.tenantId);
        break;
      case 'CUSTOMER':
        stats = await dashboardService.getCustomerDashboardStats(req.userId, req.tenantId);
        break;
      default:
        return errorResponse(res, 'Invalid user role', 400);
    }

    return successResponse(res, stats, 'Dashboard stats retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve dashboard stats', 500);
  }
};

module.exports = {
  getStats,
};

