/**
 * Compliance Controller
 */

const complianceService = require('../services/compliance.service');
const { successResponse, errorResponse, validationErrorResponse } = require('../utils/response');
const { body, validationResult } = require('express-validator');

const createComplaint = async (req, res) => {
  try {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return validationErrorResponse(res, errors.array());
    }

    const complaint = await complianceService.createComplaint(
      req.body,
      req.tenantId,
      req.userId,
      req.userRole
    );

    return successResponse(res, complaint, 'Complaint created successfully', 201);
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to create complaint', 400);
  }
};

const getComplaints = async (req, res) => {
  try {
    const filters = {
      status: req.query.status,
      priority: req.query.priority,
    };

    const complaints = await complianceService.getComplaints(
      filters,
      req.tenantId,
      req.userRole,
      req.userId
    );

    return successResponse(res, complaints, 'Complaints retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve complaints', 500);
  }
};

const validateCreateComplaint = [
  body('description').notEmpty().withMessage('Description is required'),
  body('category').optional().isString(),
];

module.exports = {
  createComplaint,
  getComplaints,
  validateCreateComplaint,
};

