/**
 * Audit Log Controller
 */

const auditLogService = require('../services/auditLog.service');
const { successResponse, errorResponse } = require('../utils/response');

const getAuditLogs = async (req, res) => {
  try {
    const filters = {
      userId: req.query.userId,
      entityType: req.query.entityType,
      entityId: req.query.entityId,
      action: req.query.action,
      startDate: req.query.startDate,
      endDate: req.query.endDate,
      limit: parseInt(req.query.limit) || 100,
    };

    const auditLogs = await auditLogService.getAuditLogs(
      filters,
      req.tenantId,
      req.userRole
    );

    return successResponse(res, auditLogs, 'Audit logs retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve audit logs', 500);
  }
};

const getAuditLogsByEntity = async (req, res) => {
  try {
    const { entityType, entityId } = req.params;
    const auditLogs = await auditLogService.getAuditLogsByEntity(
      entityType,
      entityId,
      req.tenantId
    );

    return successResponse(res, auditLogs, 'Audit logs retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve audit logs', 500);
  }
};

module.exports = {
  getAuditLogs,
  getAuditLogsByEntity,
};

