/**
 * Activity Tracking Controller
 */

const activityTrackingService = require('../services/activityTracking.service');
const { successResponse, errorResponse } = require('../utils/response');

/**
 * Get activities
 */
const getActivities = async (req, res) => {
  try {
    const filters = {
      userId: req.query.userId,
      userModel: req.query.userModel,
      activityType: req.query.activityType,
      startDate: req.query.startDate,
      endDate: req.query.endDate,
      page: req.query.page,
      limit: req.query.limit,
    };

    const result = await activityTrackingService.getActivities(filters, req.tenantId);
    return successResponse(res, result, 'Activities retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve activities', 500);
  }
};

/**
 * Get activity statistics
 */
const getActivityStats = async (req, res) => {
  try {
    const filters = {
      userId: req.query.userId,
      startDate: req.query.startDate,
      endDate: req.query.endDate,
    };

    const stats = await activityTrackingService.getActivityStats(req.tenantId, filters);
    return successResponse(res, stats, 'Activity statistics retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve activity statistics', 500);
  }
};

/**
 * Get user activity timeline
 */
const getUserActivityTimeline = async (req, res) => {
  try {
    const { userId } = req.params;
    const filters = {
      startDate: req.query.startDate,
      endDate: req.query.endDate,
    };

    const activities = await activityTrackingService.getUserActivityTimeline(userId, req.tenantId, filters);
    return successResponse(res, activities, 'User activity timeline retrieved successfully');
  } catch (error) {
    return errorResponse(res, error.message || 'Failed to retrieve user activity timeline', 500);
  }
};

module.exports = {
  getActivities,
  getActivityStats,
  getUserActivityTimeline,
};

