# HRQ Backend API

## Quick Start

### 1. Install Dependencies
```bash
npm install
```

### 2. Setup Environment Variables
Create a `.env` file:
```bash
NODE_ENV=development
PORT=3000
MONGODB_URI=mongodb://135.181.103.182:1200/hyderabad
JWT_SECRET=your-secret-key-minimum-32-characters
JWT_EXPIRATION=15m
REFRESH_TOKEN_EXPIRATION=7d

# Optional: Super Admin credentials
SUPER_ADMIN_EMAIL=superadmin@hrq.com
SUPER_ADMIN_PASSWORD=SuperAdmin@123
SUPER_ADMIN_NAME=Super Admin
```

### 3. Create Super Admin User
```bash
npm run seed:superadmin
```

This will create the initial Super Admin user for the white-label panel.

**Default Credentials**:
- Email: `superadmin@hrq.com`
- Password: `SuperAdmin@123`

### 4. Start Server
```bash
npm run dev
```

Server will run on `http://localhost:3000`

---

## API Endpoints

### Authentication
- `POST /api/v1/auth/login` - Login
- `POST /api/v1/auth/refresh-token` - Refresh token
- `POST /api/v1/auth/logout` - Logout

### Tenants (Companies)
- `GET /api/v1/tenants` - List tenants (Super Admin only)
- `POST /api/v1/tenants` - Create tenant (Super Admin only)
- `PATCH /api/v1/tenants/:id` - Update tenant
- `PATCH /api/v1/tenants/:id/activate` - Activate tenant
- `PATCH /api/v1/tenants/:id/deactivate` - Deactivate tenant
- `PATCH /api/v1/tenants/:id/white-label` - Update white-label config
- `DELETE /api/v1/tenants/:id` - Delete tenant

### Users
- `GET /api/v1/users` - List users
- `POST /api/v1/users` - Create user
- `GET /api/v1/users/:id` - Get user
- `PATCH /api/v1/users/:id` - Update user
- `DELETE /api/v1/users/:id` - Delete user

### Dashboard
- `GET /api/v1/dashboard/stats` - Get dashboard stats
- `GET /api/v1/dashboard/super-admin` - Super admin dashboard

---

## Scripts

- `npm start` - Start production server
- `npm run dev` - Start development server with nodemon
- `npm run seed:superadmin` - Create initial Super Admin user

---

## Database

MongoDB connection string: `mongodb://135.181.103.182:1200/hyderabad`

---

## Authentication

All protected routes require JWT token in header:
```
Authorization: Bearer {token}
```

---

For more details, see the main project documentation.
