# Environment Variables Setup Instructions

## 📋 Quick Setup

1. **Copy the example file**:
   ```bash
   cd backend
   cp .env.example .env
   ```

2. **Edit `.env` file** with your actual values (if needed)

3. **Restart the server**:
   ```bash
   npm run dev
   ```

---

## ✅ Required Environment Variables

### Minimum Required (for basic functionality):
```bash
MONGODB_URI=mongodb://135.181.103.182:1200/hyderabad
JWT_SECRET=your-secret-key-minimum-32-characters
```

### Recommended (for full functionality):
```bash
NODE_ENV=development
PORT=3000
MONGODB_URI=mongodb://135.181.103.182:1200/hyderabad
JWT_SECRET=hrq-super-secret-jwt-key-minimum-32-characters-for-security-2024
JWT_EXPIRATION=15m
REFRESH_TOKEN_EXPIRATION=7d
CORS_ORIGIN=http://localhost:3001,http://localhost:3002,http://localhost:5173
SUPER_ADMIN_EMAIL=superadmin@hrq.com
SUPER_ADMIN_PASSWORD=SuperAdmin@123
```

---

## 🔐 Generate Secure JWT Secret

```bash
# Using Node.js
node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"
```

---

## 📝 Environment Variables Explained

| Variable | Required | Default | Description |
|----------|----------|---------|-------------|
| `NODE_ENV` | No | `development` | Environment mode |
| `PORT` | No | `3000` | Server port |
| `MONGODB_URI` | **Yes** | - | MongoDB connection string |
| `JWT_SECRET` | **Yes** | - | Secret key for JWT tokens |
| `JWT_EXPIRATION` | No | `15m` | Access token expiration |
| `REFRESH_TOKEN_EXPIRATION` | No | `7d` | Refresh token expiration |
| `CORS_ORIGIN` | No | `localhost:3001,3002,5173` | Allowed CORS origins |
| `SUPER_ADMIN_EMAIL` | No | `superadmin@hrq.com` | Super admin email |
| `SUPER_ADMIN_PASSWORD` | No | `SuperAdmin@123` | Super admin password |

---

## 🚨 Important Notes

- **Never commit `.env` file** - It's in `.gitignore`
- **Use strong secrets in production**
- **Update `CORS_ORIGIN`** for production domains
- **Change default passwords** after first login

---

**After creating `.env`, restart the backend server!** ✅

