# Environment Variables Setup

## ⚠️ JWT_SECRET Error Fix

If you're getting "secretOrPrivateKey must have a value" error, you need to set the `JWT_SECRET` environment variable.

---

## ✅ Quick Fix

### Option 1: Create .env file (Recommended)

Create a file named `.env` in the `backend` folder:

```bash
# backend/.env
JWT_SECRET=your-super-secret-jwt-key-minimum-32-characters-long-for-security
JWT_EXPIRATION=15m
REFRESH_TOKEN_EXPIRATION=7d
MONGODB_URI=mongodb://135.181.103.182:1200/hyderabad
PORT=3000
```

### Option 2: Use Default (Development Only)

The code now has a default fallback, but **this is NOT secure for production**.

For production, you MUST set `JWT_SECRET` in your environment.

---

## 📝 Complete .env File

Create `backend/.env` with:

```bash
# Application
NODE_ENV=development
PORT=3000

# Database
MONGODB_URI=mongodb://135.181.103.182:1200/hyderabad

# JWT Configuration (REQUIRED)
JWT_SECRET=your-super-secret-jwt-key-minimum-32-characters-long-for-security
JWT_EXPIRATION=15m
REFRESH_TOKEN_EXPIRATION=7d

# CORS
CORS_ORIGIN=http://localhost:3001,http://localhost:3002,http://localhost:5173

# Super Admin (for seeding)
SUPER_ADMIN_EMAIL=superadmin@hrq.com
SUPER_ADMIN_PASSWORD=SuperAdmin@123
SUPER_ADMIN_NAME=Super Admin
```

---

## 🔐 Generate Secure JWT Secret

You can generate a secure random secret:

```bash
# Using Node.js
node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"

# Or use online generator
# https://www.grc.com/passwords.htm
```

---

## ✅ After Creating .env

1. **Restart Backend Server**:
   ```bash
   cd backend
   npm run dev
   ```

2. **Try Login Again**:
   - Go to `http://localhost:3002/login`
   - Email: `superadmin@hrq.com`
   - Password: `SuperAdmin@123`

---

## 🚨 Important Notes

- **Never commit `.env` file to git** (it should be in `.gitignore`)
- **Use strong, random secrets in production**
- **Default fallback is for development only**

---

**Create the `.env` file and restart the server!** ✅

